/*
PREVIEW FOR WRITEMONKEY

Version: 1.2, requires Writemonkey 2.7.0.2 or higher

Release date: November 8th 2014
Author: Josip

Description:  
Offers live preview and template picker for your markdown, textile or wiki texts.

Installation:  
Unzip the "Preview" directory into the plugins directory.

Deployment:  
This plugin is initialized at start-up. Use ALT+Y to toggle visibility.
*/

monkey.include("_config.incl");
monkey.include("_config_user.incl");

var oldNumOfLines = 0;
var currentCSS = "";
var isInit = false;
var showHeadingNumbers = false;
var wmColorScheme = WM_COLORS_ON_START;

var getTextColor = function() {
	return (USE_DIMMED_COLOR) ? monkey.dimmedColor : monkey.inkColor;
};


// Initialize markdown parser
var md = monkey.getMarkdownDeepInstance();
md.ExtraMode = true;
md.SafeMode = false;

// Initialize wiki parser
var wiki = monkey.getCreoleParserInstance();



var pluginForm = monkey.getBlankPluginForm(INITIAL_SIZE[0], INITIAL_SIZE[1]);
pluginForm.Location = new System.Drawing.Point(INITIAL_POSITION[0], INITIAL_POSITION[1]);
pluginForm.Padding = new System.Windows.Forms.Padding(15, 20, 15, 55);
pluginForm.BackColor = monkey.paperColor;
pluginForm.deactivatedOpacity = DEACTIVATED_OPACITY;
pluginForm.showMinimizeButton = false;
pluginForm.mouseCapturing = false;
pluginForm.MinimumSize = new System.Drawing.Size(100, 95);
pluginForm.roundedCorners = 1;


var wb = new System.Windows.Forms.WebBrowser();
wb.ScrollBarsEnabled = false;
wb.Dock = System.Windows.Forms.DockStyle.Fill;
wb.AllowNavigation = true;
wb.Navigate("about:blank");
// <meta http-equiv="X-UA-Compatible" content="IE=Edge" />

var templateLabel = new System.Windows.Forms.Label();
// templateLabel.ForeColor = getTextColor();
// templateLabel.BackColor = monkey.paperColor;
templateLabel.Padding = new System.Windows.Forms.Padding(2);
templateLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
templateLabel.Font = new System.Drawing.Font(templateLabel.Font.Name, 9, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
templateLabel.AutoSize = true;
//templateLabel.Width = pluginForm.Width - 15;
templateLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
templateLabel.Location = new System.Drawing.Point(10, pluginForm.Height - templateLabel.Height);
templateLabel.Text = monkey.settings["_exportSelectedTemplate"];
templateLabel.Cursor = System.Windows.Forms.Cursors.Hand;


var templatesContextMenuStrip = new System.Windows.Forms.ContextMenuStrip();
templatesContextMenuStrip.ShowImageMargin = true;
templatesContextMenuStrip.ShowShortcutKeys = false;
//templatesContextMenuStrip.Font = new System.Drawing.Font(UI_FONT_NAME, templatesContextMenuStrip.Font.Size, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);

var getHtml = function() {

	var docName = (monkey.fileName == "-1") ? "" : monkey.fileName;
	var css = getCSS();
	var body = getBody();

	var bc = monkey.paperColor;
	var bcHex = "#" + bc.R.ToString("X2") + bc.G.ToString("X2") + bc.B.ToString("X2");
	var fc = getTextColor();
	var fcHex = "#" + fc.R.ToString("X2") + fc.G.ToString("X2") + fc.B.ToString("X2");

	var cssInjection = (wmColorScheme) ? CSS_FOR_WM_COLORS.replace(/\[_bck_color_\]/g, bcHex).replace(/\[_txt_color_\]/g, fcHex) : "";

	cssInjection += (showHeadingNumbers) ? CSS_FOR_NUMBERED_HEADINGS : "";

	var bodyStyle = (wmColorScheme) ? "style=\"overflow:hidden;\"" : "style=\"overflow:auto;\"";

	return FULL_HTML.replace("[_doc_name_]", docName).replace("[_parsed_html_]", body).replace("[_parsed_css_]", css + cssInjection).replace("[_doc_name_]", docName).replace("[_body_style_]", bodyStyle);
};


var getCSS = function() {
	if (monkey.settings["_exportIncludeStyles"]) {
		return currentCSS;
	} else {
		return "";
	}
};


var getBody = function() {
	var t = monkey.text
		.replace(/\$/g, "&#36;");

	switch (monkey.settings["_exportMarkupStandard"]) {
		case 0:
		case 3:
			return md.Transform(preparse(t));
			break;
		case 1:
			return monkey.getTextile(preparse(t));
			break;
		case 2:
			return wiki.ToHTML(preparse(t));
			break;
		default:
			return md.Transform(preparse(t));
	}
};


var preparse = function(text) {

	if (monkey.settings["_exportComments"]) {
		return System.Text.RegularExpressions.Regex.Replace(text, "^//(.*?$)", "<div class=\"comment\" style=\"background-color:#EFE577; padding:3px;\">" + "$1" + "</div>", System.Text.RegularExpressions.RegexOptions.Multiline);
	} else {
		return System.Text.RegularExpressions.Regex.Replace(text, "^//(.*?$)", "", System.Text.RegularExpressions.RegexOptions.Multiline);
	}
};



var updateContents = function() {

	if (!pluginForm.Visible) return;

	while (wb.Document == null || wb.Document.Body == null) {
		System.Windows.Forms.Application.DoEvents();
	}
	try {
		wb.Document.OpenNew(false).Write(getHtml());
		//wb.Document.BackColor = monkey.paperColor;
	} catch (e) {

	}
};


var setZoomFactor = function() {
	// var percent = 50;
	// wb.Document.Body.Style = "zoom:" + percent + "%;";
};


var setScrollPosition = function() {

	if (!pluginForm.Visible) return;


	var maxScrollBrowser = wb.Document.Body.ScrollRectangle.Height;
	var maxScrollRtf = monkey.form.maxScrollPosition;
	var currentScrollRtf = monkey.richTextBox.ScrollPos.Y;
	var percentRtf = System.Convert.ToDouble(currentScrollRtf) / System.Convert.ToDouble(maxScrollRtf) * 100;
	var newAbsoluteBrowser = (System.Convert.ToDouble(maxScrollBrowser) / 100 * percentRtf) - (wb.Height / 2);

	try {
		wb.SuspendLayout();
		wb.Document.Window.ScrollTo(0, newAbsoluteBrowser);
		wb.ResumeLayout();


	} catch (e) {
		wb.ResumeLayout();
	}
};


var updateAndScroll = function() {
	updateContents();
	setScrollPosition();
};


var positionElements = function() {
	templateLabel.SetBounds((pluginForm.Width / 2) - (templateLabel.Width / 2), pluginForm.Height - 30, pluginForm.Width, templateLabel.Height);
};

var colorElements = function() {
	pluginForm.BackColor = monkey.paperColor;
	templateLabel.BackColor = monkey.paperColor;
	templateLabel.ForeColor = getTextColor();
	// templateLabel.BackColor = getTextColor();
	// templateLabel.ForeColor = monkey.paperColor;
};

var setTemplatesContextMenu = function() {
	templatesContextMenuStrip.Items.Clear();

	var numberedHeadingsItem = new System.Windows.Forms.ToolStripMenuItem(NUMBERED_HEADINGS_S);
	numberedHeadingsItem.Checked = showHeadingNumbers;
	numberedHeadingsItem.CheckedState = System.Windows.Forms.CheckState.Checked;
	numberedHeadingsItem.Tag = "=nh=";
	templatesContextMenuStrip.Items.Add(numberedHeadingsItem);

	var includeCommentsItem = new System.Windows.Forms.ToolStripMenuItem(INCLUDE_COMMENTS_S);
	includeCommentsItem.Checked = monkey.settings["_exportComments"];
	includeCommentsItem.CheckedState = System.Windows.Forms.CheckState.Checked;
	includeCommentsItem.Tag = "=ic=";
	templatesContextMenuStrip.Items.Add(includeCommentsItem);


	var wmColorSchemeItem = new System.Windows.Forms.ToolStripMenuItem(WM_COLORS_S);
	wmColorSchemeItem.Checked = wmColorScheme;
	wmColorSchemeItem.CheckedState = System.Windows.Forms.CheckState.Checked;
	wmColorSchemeItem.Tag = "=wc=";
	templatesContextMenuStrip.Items.Add(wmColorSchemeItem);


	var separator = new System.Windows.Forms.ToolStripSeparator();
	templatesContextMenuStrip.Items.Add(separator);

	var noStyleItem = new System.Windows.Forms.ToolStripMenuItem(NO_STYLE_S);
	noStyleItem.Checked = !monkey.settings["_exportIncludeStyles"];
	noStyleItem.CheckedState = System.Windows.Forms.CheckState.Checked;
	noStyleItem.Tag = "=ns=";
	templatesContextMenuStrip.Items.Add(noStyleItem);



	var templatePaths = System.IO.Directory.GetFiles(monkey.applicationStartupPath + "/templates", "*.template");

	for (var i = 0; i < templatePaths.Length; i++) {
		var templateName = System.IO.Path.GetFileNameWithoutExtension(templatePaths[i]);
		var item = new System.Windows.Forms.ToolStripMenuItem(templateName);
		item.Tag = templatePaths[i];
		item.CheckedState = System.Windows.Forms.CheckState.Checked;
		item.Checked = (templateName == monkey.settings["_exportSelectedTemplate"] && monkey.settings["_exportIncludeStyles"]) ? true : false;
		templatesContextMenuStrip.Items.Add(item);
	}
};

var setCurrentCSSFromFile = function() {
	var templateName = monkey.settings["_exportSelectedTemplate"];
	var path = monkey.applicationStartupPath + "/templates/" + templateName + ".template";
	currentCSS = System.IO.File.ReadAllText(path, System.Text.Encoding.UTF8);
	templateLabel.Text = (monkey.settings["_exportIncludeStyles"]) ? templateName : NO_STYLE_S;

};

var showHide = function() {
	if (pluginForm.Visible) {
		pluginForm.Hide();
	} else {
		pluginForm.Show();
		if (!isInit) {
			pluginForm.SetBounds(INITIAL_POSITION[0], INITIAL_POSITION[1], INITIAL_SIZE[0], INITIAL_SIZE[1]);
			colorElements();
			isInit = true;
		}
		updateAndScroll();
		monkey.richTextBox.Focus();
	}
};



/*
########   ##     ##  ########   ##    ##   ########    ######    
##         ##     ##  ##         ###   ##      ##      ##    ##   
##         ##     ##  ##         ####  ##      ##      ##         
######     ##     ##  ######     ## ## ##      ##       ######    
##          ##   ##   ##         ##  ####      ##            ##   
##           ## ##    ##         ##   ###      ##      ##    ##   
########      ###     ########   ##    ##      ##       ######    
*/


pluginForm.add_DoubleClick(function(object, eventargs) {
	wmColorScheme = !wmColorScheme;
	updateAndScroll();
});

pluginForm.add_Paint(function(object, eventargs) {
	if (pluginForm.ContainsFocus || BORDER_ALWAYS_ON) {
		var rect = new System.Drawing.Rectangle(0, 0, pluginForm.Width - 2, pluginForm.Height - 2);
		var pen = new System.Drawing.Pen(getTextColor(), 1);
		pen.DashStyle = System.Drawing.Drawing2D.DashStyle.Dot;
		eventargs.Graphics.DrawRectangle(pen, rect);
	}
});

pluginForm.add_SizeChanged(function(object, eventargs) {
	positionElements();
	// setZoomFactor();
});


monkey.richTextBox.add_VScroll(function(object, eventargs) {
	if (!monkey.richTextBox.isUpdating) {
		setScrollPosition();
	}
});


monkey.richTextBox.add_TextChanged(function(object, eventargs) {
	var numOfLinesTest = monkey.richTextBox.Lines.Length - 1;
	if (numOfLinesTest != oldNumOfLines) {
		updateAndScroll();
		oldNumOfLines = numOfLinesTest;
	}

});


wb.add_DocumentCompleted(function(object, eventargs) {
	// monkey.playSound();
});


pluginForm.add_Deactivate(function(object, eventargs) {
	wb.Focus();
	monkey.richTextBox.Focus();

	pluginForm.Invalidate();

});

pluginForm.add_Activated(function(object, eventargs) {
	pluginForm.Invalidate();

});


wb.add_LostFocus(function(object, eventargs) {
	// wb.ScrollBarsEnabled = false;
});

wb.add_Navigating(function(object, eventargs) {
	eventargs.Cancel = true;
	try {
		System.Diagnostics.Process.Start(eventargs.Url.ToString()); // handle spaces
	} catch (e) {
		// psst
	}
});



monkey.add_beforeSaveE(function(object, eventargs) {
	updateAndScroll();

});

templateLabel.add_Click(function(object, eventargs) {
	//monkey.playSound();
	setTemplatesContextMenu();
	templatesContextMenuStrip.Show(new System.Drawing.Point(System.Windows.Forms.Cursor.Position.X, System.Windows.Forms.Cursor.Position.Y));
});

templatesContextMenuStrip.add_ItemClicked(function(object, eventargs) {

	if (eventargs.ClickedItem.Tag == "=ns=") {
		monkey.setSettingValue("_exportIncludeStyles", false);
	} else if (eventargs.ClickedItem.Tag == "=nh=") {
		showHeadingNumbers = !eventargs.ClickedItem.Checked;
		eventargs.ClickedItem.Checked = showHeadingNumbers;
	} else if (eventargs.ClickedItem.Tag == "=ic=") {
		monkey.setSettingValue("_exportComments", !monkey.settings["_exportComments"]);
	} else if (eventargs.ClickedItem.Tag == "=wc=") {
		wmColorScheme = !eventargs.ClickedItem.Checked;
		eventargs.ClickedItem.Checked = wmColorScheme;
	} else {
		monkey.setSettingValue("_exportIncludeStyles", true);
		monkey.setSettingValue("_exportSelectedTemplate", eventargs.ClickedItem.Text);
	}
	setCurrentCSSFromFile();


	positionElements();
	updateAndScroll();
});

monkey.richTextBox.add_ForeColorChanged(function(object, eventargs) {
	colorElements();
});


// Entry point event / shortcut fired
monkey.add_keyDownE(function(object, eventargs) {
	if (eventargs.KeyCode == System.Windows.Forms.Keys.Y && System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Alt) {
		showHide();
	}
});



/*
########   ##    ##   ########   ########   ##    ##   
##         ###   ##      ##      ##     ##   ##  ##    
##         ####  ##      ##      ##     ##    ####     
######     ## ## ##      ##      ########      ##      
##         ##  ####      ##      ##   ##       ##      
##         ##   ###      ##      ##    ##      ##      
########   ##    ##      ##      ##     ##     ##      
*/

pluginForm.Controls.Add(wb);
pluginForm.Controls.Add(templateLabel);
setCurrentCSSFromFile();