﻿/*
Version: 1.0, requires Writemonkey 2.5.0.8 or higher

Release date: August 25th 2013

Author: Josip

Description: 
Show timer and completed pomodoros with words written for each of them. Track how productive you were during the session. More about this technique at http://www.pomodorotechnique.com.

Installation:
Unzip the "Pomodoro" directory into the plugins directory.

Deployment:
This plugin is initialized at startup. Show / hide with CTRL+E,P. Click timer to start / void pomodoro. Click session label to start new session. More settings at the beginning of the plugin file.
*/


var shortcutKey = "P"; // Use CTRL+E,P

var pomodoroSequence = "*-*-*-*="; // (*) write (-) break (=) long break 
var pomodoroWriteTime = 25; // in minutes
var pomodoroShortBreakTime = 5;
var pomodoroLongBreakTime = 20;
var lockInputOnBreak = false;
var playSounds = true;

// Strings
var startS = "Start";
var voidS = "Void - click timer to restart";
var pomodorosLostS = "All pomodoros will be lost. Sure?";
var newSessionS = "New session";
var sessionFileS = "Session file: "
var clickToStartS = "Click timer to start";
var noneS = "none";
var writeS = "Write";
var shortBreakS = "Short break";
var longBreakS = "Long break";


// UI stuff

// New blank plugin form
var pluginForm = monkey.getBlankPluginForm(300, 250);
pluginForm.Width = 300;
pluginForm.softClose = true;
pluginForm.BackColor = monkey.dimmedColor;
pluginForm.ForeColor = monkey.paperColor;
pluginForm.deactivatedOpacity = 0.8;

// Timer label
var timerLabel = new System.Windows.Forms.Label();
timerLabel.BackColor = System.Drawing.Color.Transparent;
timerLabel.Location = new System.Drawing.Point(0, 40);
timerLabel.Size = new System.Drawing.Size(pluginForm.Width, 40);
timerLabel.Font = new System.Drawing.Font("Arial", 30, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point);
timerLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
timerLabel.Text = "00:00";
timerLabel.Cursor = System.Windows.Forms.Cursors.Hand;
timerLabel.add_Click(function(object, eventargs) {
	plugin.ses.startAction();
});

// File label
var fileLabel = new System.Windows.Forms.Label();
fileLabel.BackColor = System.Drawing.Color.Transparent;
fileLabel.Location = new System.Drawing.Point(9, 9);
//fileLabel.Size = new System.Drawing.Size(pluginForm.Width - 30, 15);
fileLabel.AutoSize = true;
fileLabel.Font = new System.Drawing.Font("Arial", 8, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point);
fileLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
fileLabel.Text = sessionFileS;
fileLabel.Cursor = System.Windows.Forms.Cursors.Hand;
fileLabel.add_Click(function(object, eventargs) {
	var result = System.Windows.Forms.MessageBox.Show(pomodorosLostS, newSessionS, System.Windows.Forms.MessageBoxButtons.OKCancel);
	if (result == System.Windows.Forms.DialogResult.OK) {
		plugin.ses = null;
		plugin.startSession();
		plugin.ses.startAction();	
	}
});

// sessionTime label
var sessionTimeLabel = new System.Windows.Forms.Label();
sessionTimeLabel.BackColor = System.Drawing.Color.Transparent;
sessionTimeLabel.Location = new System.Drawing.Point(9, pluginForm.Height - 25);
//sessionTimeLabel.Size = new System.Drawing.Size(pluginForm.Width - 10, 15);
sessionTimeLabel.AutoSize = true;
sessionTimeLabel.Font = new System.Drawing.Font("Arial", 8, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point);
sessionTimeLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
sessionTimeLabel.Text = "0h 0m";


// sessionWords label
var sessionWordsLabel = new System.Windows.Forms.Label();
sessionWordsLabel.BackColor = System.Drawing.Color.Transparent;
sessionWordsLabel.Location = new System.Drawing.Point(pluginForm.Width - 55, pluginForm.Height - 25);
sessionWordsLabel.Size = new System.Drawing.Size(40, 15);
sessionWordsLabel.AutoSize = false;
sessionWordsLabel.Font = new System.Drawing.Font("Arial", 8, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point);
sessionWordsLabel.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
sessionWordsLabel.Text = "0";

// Action label
var actionLabel = new System.Windows.Forms.Label();
actionLabel.BackColor = System.Drawing.Color.Transparent;
actionLabel.Location = new System.Drawing.Point(0, 85);
actionLabel.Size = new System.Drawing.Size(pluginForm.Width, 20);
actionLabel.Font = new System.Drawing.Font("Arial", 9, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point);
actionLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
actionLabel.Text = clickToStartS;



// Pomodoros panel
var ppanel = new System.Windows.Forms.Panel();
ppanel.BackColor = System.Drawing.Color.Transparent;
ppanel.Location = new System.Drawing.Point(0, 120);
ppanel.Size = new System.Drawing.Size(pluginForm.Width, 90);

// .net timer
var timer1 = new System.Windows.Forms.Timer();
timer1.Interval = 1000;


// Add controls to form
pluginForm.Controls.Add(fileLabel);
pluginForm.Controls.Add(timerLabel);
pluginForm.Controls.Add(actionLabel);
pluginForm.Controls.Add(ppanel);
pluginForm.Controls.Add(sessionTimeLabel);
pluginForm.Controls.Add(sessionWordsLabel);


// Init plugin at sturtup
var plugin = new Plugin();
plugin._init();


// Entry point event / shortcut fired
monkey.add_extendedShortcutFiredE(function(object, eventargs) {
	if (eventargs.extendedKey == shortcutKey) {
		plugin.toggleFormVisibility();
		plugin.startSession();
	}
});


ppanel.add_Paint(function(object, eventargs) {
	plugin.ses.drawPomodoros();
});





timer1.add_Tick(function(object, eventargs) {

	tick();
});


function tick () {
	if (plugin.ses.sessionActive) {

		// Update main timer
		var currentTime = monkey.dateTimeNow;
		var timespan = new System.TimeSpan(); 
		timespan = plugin.ses.endTime.Subtract(currentTime);

		if (pluginForm != null) {
			timerLabel.Text = timespan.Minutes.ToString("0") + ":" + timespan.Seconds.ToString("00");
			if (timespan.Hours == 0 && timespan.Minutes == 0 && timespan.Seconds == 0) {
			 	plugin.ses.stopAction();
			}
		}
		// Update session time;
		var timespan2 = new System.TimeSpan();
		timespan2 = currentTime.Subtract(plugin.ses.sessionStartTime);
		sessionTimeLabel.Text = timespan2.Hours.ToString("0") + "h " + timespan2.Minutes.ToString("0") + "m";
	}
}



//
// class plugin
//

function Plugin () {

	this.ses;

	this._init = function () {
		timerLabel.Text = pomodoroWriteTime + ":00";
	};

	this.startSession = function () {
		if (this.ses == null) {
			this.ses = new Session(monkey.fileName, monkey.fileHolder);
			this.ses._init();
		}
	};

	this.startTimer = function () {
		timer1.Start();
	};

	this.stopTimer = function () {
		timer1.Stop();
	};


	this.showPlugin = function () {
		pluginForm.Visible = true;
		pluginForm.Show();
		ppanel.Invalidate();
	};

	this.hidePlugin = function () {
		pluginForm.Visible = false;
	};


	this.toggleFormVisibility = function () {
		if (pluginForm.Visible == false) {
			this.showPlugin();
		}
		else {
			this.hidePlugin();
		}

	};

}



//
// class session
//
function Session (file, fileholder) {

	this.fileName = file;
	this.fileHolder = fileholder;
	this.pomodoroList = new Array();
	this.sessionActive = false;
	this.totalTime = 0;
	this.totalWords = 0;
	this.sessionStartTime;
	this.endTime;
	this.paused = false;
	
	this.sessionInitialWords = 0;

	this.currentPomodoro = null;
	this.currentPomodoroSequence  = 0;
	this.pomodorosCompleted = 0;
	this.shortBreaksCompleted = 0;
	this.longBreaksCompleted = 0;

	this._init = function () {
		this.sessionStartTime = monkey.dateTimeNow;
		this.sessionInitialWords = this.getPomodoroWords();
		sessionWordsLabel.Text = "0";	
	};

	this.startAction = function () {

		if (this.sessionActive) {
			this.voidAction();
			actionLabel.Text = voidS;
			return;
		}

		if (this.paused) {
			var t = monkey.dateTimeNow;
			this.endTime = t.AddMinutes(this.currentPomodoro.pomodoroTime);
			plugin.startTimer();
			this.paused = false;
			this.currentPomodoroSequence--;
			this.startAction();
			return;
		}

		// Play sound
		if (playSounds)
		 monkey.playSound(monkey.pluginDirectoryPath + "/start.wav");

		// Create new pomodoro
		this.currentPomodoro = this.startNewPomodoro(pomodoroSequence.charAt(this.currentPomodoroSequence));

		if (this.currentPomodoroSequence == pomodoroSequence.length - 1) {
			this.currentPomodoroSequence = 0;
		}
		else {
			this.currentPomodoroSequence++;
		}


		if (this.currentPomodoro.type == "*")
			monkey.richTextBox.ReadOnly = false;
		else if (lockInputOnBreak)
			monkey.richTextBox.ReadOnly = true;

		this.fileName = (this.fileName == "-1") ? noneS : this.fileName;
		fileLabel.Text = sessionFileS + this.fileName;
		actionLabel.Text = this.currentPomodoro.actionDescription;
		this.sessionActive = true;
		ppanel.Invalidate();
		plugin.showPlugin();
		plugin.startTimer();

		var t = monkey.dateTimeNow;
		this.endTime = t.AddMinutes(this.currentPomodoro.pomodoroTime);

	};

	this.stopAction = function () {

		// Play sound
		if (playSounds)
			monkey.playSound(monkey.pluginDirectoryPath + "/stop.wav");

		plugin.stopTimer();
		this.sessionActive = false;
		
		if (this.currentPomodoro.type == "*") {
			var w = this.getPomodoroWords();
			this.currentPomodoro.words = w - this.currentPomodoro.initialWords;
			sessionWordsLabel.Text = w - this.sessionInitialWords;
		}
		// add completed pomodoro
		this.addCompletedPomodoro(this.currentPomodoro);
		this.pomodorosCompleted++;
		currentPomodoro = null;

		this.startAction();
	};

	this.voidAction = function() {
		this.paused = true;
		this.sessionActive = false;
		plugin.stopTimer();
	};

	this.getPomodoroWords = function() {

		if (this.fileHolder == monkey.fileHolder) {
			return monkey.getWordsFromString(monkey.mainText)
		}
		else {
			var parts = monkey.getPartsFromFile(this.fileHolder);
			return monkey.getWordsFromString(parts[0]);
		}
	};

	this.addCompletedPomodoro = function(p) {
		p.completed = true;
		p._init();
		this.pomodoroList.push(p);
	};


	this.startNewPomodoro = function(type) {
		var p = new Pomodoro(type);
		p._init();
		return p;
	};

// draw % pie code 
									// Percent pie
				                    //SolidBrush bru = new SolidBrush(this.ForeColor);
				                    //SolidBrush bru2 = new SolidBrush(this.BackColor);
				                    //Pen pen = new Pen(bru, 1);
				                    //Rectangle rec = new Rectangle(this.Width - 28, 30, 19, 19);


				                    //float total = 100;
				                    //float deg1 = 360;// (0.01F * 360);
				                    //float deg2 = ((projectFileO.percentDone / total) * 360);

				                    //g.DrawEllipse(pen, rec);
				                    //g.FillPie(bru, rec, deg1, deg2);

				                    //SolidBrush bru = new SolidBrush(this.ForeColor);
				                    //Rectangle rec2 = new Rectangle(0, this.Height - 3, projectFileO.percentDone * this.Width / 100, 3);
				                    //g.FillRectangle(bru, rec2);

	// Draw pomodoros
	this.drawPomodoros = function() {

		if (this.currentPomodoro == null) return;

		var pg = ppanel.CreateGraphics();
		pg.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
		var pX = 10;
		var pY = 0;

		for (var i = 0; i < this.pomodoroList.length; i++) {
			var s = this.pomodoroList[i].size;
			
			var brush = new System.Drawing.SolidBrush(this.pomodoroList[i].color);
			var rect = new System.Drawing.Rectangle(pX, pY, s, s);
			
			// Draw pomodoro
			pg.FillEllipse(brush, rect);

			// Draw words
			if (this.pomodoroList[i].type == "*") {

				var drawFont = new System.Drawing.Font("Arial", 7);
				var drawBrush = new System.Drawing.SolidBrush(monkey.paperColor);
				// Set format of string.
				var drawFormat = new System.Drawing.StringFormat();
				//drawFormat.FormatFlags = System.Drawing.StringFormatFlags.DirectionVertical;
				// Draw string to screen.
				pg.DrawString(this.pomodoroList[i].words, drawFont, drawBrush, pX, pY + 30, drawFormat);

			}

			var step = s * 0.1;
			pX = pX + step + 18;

			// Second line
			if (i == 13) {
				pX = 10;
				pY = 45;
			}
		}

		// Draw current pomodoro
		var s = this.currentPomodoro.size;
		var brush = new System.Drawing.SolidBrush(monkey.paperColor);
		var rect = new System.Drawing.Rectangle(pX, pY, s, s);
		pg.FillEllipse(brush, rect);

		pg.Dispose();
	};

	this.exportPomodoros = function() {
		// export json
	};

	this.importPomodoros = function() {
		// import json
	};
}

//
// class pomodoro
//
function Pomodoro (type) {
    this.type = type;
    this.actionDescription;
    this.completed = false;
    this.pomodoroTime;
    this.started;
    this.ended;
    this.initialWords;
    this.words = 0;
    this.voided = false;
    this.size;
    this.color;

    

    //
    this._init = function () {

    	this.initialWords = plugin.ses.getPomodoroWords();
    	switch (this.type) {
    		case "*":
    			this.size = 28;
    			this.color = (this.completed) ? System.Drawing.Color.DarkRed : pluginForm.ForeColor;
    			this.pomodoroTime = pomodoroWriteTime;
    			this.actionDescription = writeS;
    			break;
    		case "-":
    			this.size = 12;
    			this.color = (this.completed) ? System.Drawing.Color.DarkGreen : pluginForm.ForeColor;
    			this.pomodoroTime = pomodoroShortBreakTime;
    			this.actionDescription = shortBreakS;
    			break;
    		case "=":
    			this.size = 15;
    			this.color = (this.completed) ? System.Drawing.Color.DarkOliveGreen : pluginForm.ForeColor;
    			this.pomodoroTime = pomodoroLongBreakTime;
    			this.actionDescription = longBreakS;
    			break;
    		default:
    			this.size = 28;
    			this.color = (this.completed) ? System.Drawing.Color.DarkRed : pluginForm.ForeColor;
    			this.pomodoroTime = pomodoroWriteTime;
    	}
    };
}
