﻿/*
##    ##    #######   ########   ##     ##   ######    ########   ####  ########   ########   ##    ##   
###   ##   ##     ##  ##     ##  ###   ###  ##    ##   ##          ##      ##      ##         ###   ##   
####  ##   ##     ##  ##     ##  #### ####  ##         ##          ##      ##      ##         ####  ##   
## ## ##   ##     ##  ########   ## ### ##   ######    ######      ##      ##      ######     ## ## ##   
##  ####   ##     ##  ##   ##    ##     ##        ##   ##          ##      ##      ##         ##  ####   
##   ###   ##     ##  ##    ##   ##     ##  ##    ##   ##          ##      ##      ##         ##   ###   
##    ##    #######   ##     ##  ##     ##   ######    ########   ####     ##      ########   ##    ##   


Version: 1.2, requires Writemonkey 2.6.0.2 or higher

Release date: May 31st 2014

Author: Josip (Special thanks to Richard Norden)

Description: 
Calculate exact number of lines and pages for a given text based on number of characters in a line and number of lines on a standard page. The default is 60 characters per line, 30 lines per page (German standard page). The plugin also checks for forced page breaks - +++ or *** lines. The commented paragraphs (//) are excluded from the count.

Installation:
Unzip the "Normseiten" directory into the plugins directory.

Deployment:
Use CTRL+3 shortcut to show the stats in Info bar (Notices must be enabled in Preferences / Screen Elements)
*/



// Settings

SHORTCUT_KEY             = System.Windows.Forms.Keys.D3; // Control + 3
NUMBER_OF_CHARS_PER_LINE = 60;
NUMBER_OF_LINES_PER_PAGE = 30;
REMOVE_BLANK_LINES       = false;
REMOVE_COMMENTS          = true;

PAGES_S                  = "Pages: ";
LINES_S                  = "Lines: ";

////////////////////////////////////////////////////////////////////////////////


// Entry point event / shortcut fired
monkey.add_keyDownE(function(object, eventargs) {
	if (eventargs.KeyCode == SHORTCUT_KEY && System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Control) {
		showNormseiten();
	}
});

monkey.add_textChangedE(function(object, eventargs) {
	if (isShown) {
		monkey.showNotice("", true, false);
		isShown = false;
	}
});


var isShown = false;

function showNormseiten() {
	isShown = true;
	var textToProcess = (monkey.selectionLength > 0) ? monkey.selectedText : monkey.text;
	// Remove comments
	textToProcess = (REMOVE_COMMENTS) ? System.Text.RegularExpressions.Regex.Replace(textToProcess, "^//.+?\n", "", System.Text.RegularExpressions.RegexOptions.Multiline) : textToProcess;

	var linesAndPagesO = getLinesAndPages(wordwrap(textToProcess, NUMBER_OF_CHARS_PER_LINE, "\n", true));
	var noticeString = LINES_S + linesAndPagesO.lines + "  " + PAGES_S + linesAndPagesO.pages;
	
	monkey.showNotice(noticeString, false, false);
}


function getLinesAndPages(linesA) { // takes an array of lines
	var pages = 0;
	var lines = 0;
	var linesOnPage = 0;
	var currentPage = 0;

	for (var i = 0; i < linesA.length; i++) {
		lines++;
		linesOnPage++;
		if (linesOnPage >= NUMBER_OF_LINES_PER_PAGE) {
			pages++;
			linesOnPage = 0;
		} else if (/^[\+\*]{3,}/.test(linesA[i])) {
			pages++;
			linesOnPage = 0;
			lines--;
		}
	}

	var lastPagePercent = linesOnPage / NUMBER_OF_LINES_PER_PAGE;

	var retO = {};
	retO.pages = (pages + lastPagePercent).toFixed(1);
	retO.lines = lines;
	retO.currentPage = currentPage;
	return retO;
}



function wordwrap(str, int_width, str_break, cut) {
	var m = ((arguments.length >= 2) ? arguments[1] : 60);
	var b = ((arguments.length >= 3) ? arguments[2] : "\n");
	var c = ((arguments.length >= 4) ? arguments[3] : false);

	var i, j, l, s, r;

	str += '';

	if (m < 1) {
		return str;
	}

	for (i = -1, l = (r = str.split(/\r\n|\n|\r/)).length; ++i < l; r[i] += s) {
		for (s = r[i], r[i] = ""; s.length > m; r[i] += s.slice(0, j) + ((s = s.slice(j)).length ? b : "")) {
			j = c == 2 || (j = s.slice(0, m + 1).match(/\S*(\s)?$/))[1] ? m : j.input.length - j[0].length || c == 1 && m || j.input.length + (j = s.slice(m).match(/^\S*/)).input.length;
		}
	}

	var trimmed = (REMOVE_BLANK_LINES) ? trimDoubles(r.join("\n")) : r.join("\n");
	return trimmed.split(/\r\n|\r|\n/);
}


function trimDoubles(str) {
	return str.replace(/\n{2,}/mg, "\n");
}